<?php
/*
Plugin Name: BizVektor Vast
Plugin URI:
Description: BizVektorテーマ用の拡張デザインスキン「vast」を追加するプラグインです。有効化した後に、デザイン選択のプルダウンで「Vast」が選択出来るようになります。
Author:Vektor,Inc.
Author URI:http://www.vektor-inc.co.jp
Version:1.0.6
*/

/*
一つ目の biz_vektor_themePlus はテーマ側で用意されているフィルターフック名
二つ目の themePlusOriginal はフィルター処理の関数名。任意に変更可ですが下の行の function と同じ名前にして下さい。
【重要】★テーマ識別用引値★は３つとも同じ値を入力して下さい。
【重要】複数の拡張テーマプラグインを同時に有効化する場合は、フィルター処理の関数名がダブらないように注意して下さい。
*/

add_filter('biz_vektor_themePlus','themePlusvast');
function themePlusvast($biz_vektor_theme_styles){
    $biz_vektor_theme_styles['vast']['label'] = 'vast';
    $biz_vektor_theme_styles['vast']['cssPath'] = plugins_url("css/vast.css", __FILE__);
    $biz_vektor_theme_styles['vast']['cssPathOldIe'] = plugins_url("css/vast_old_ie.css", __FILE__);
    return $biz_vektor_theme_styles;
}

/*-------------------------------------------*/
/*  今適応されているテーマを取得
/*-------------------------------------------*/
function is_vast(){
    if (function_exists('biz_vektor_theme_styleSetting'))
    {
        $options = biz_vektor_get_theme_options();
        if ($options['theme_style'] == 'vast') {
            return true;
        }
    }
}

add_action( 'after_setup_theme', 'vast_run' );

function vast_run(){
    if (is_vast()){
        add_action( 'admin_init', 'biz_vektor_theme_options_vast_init' );
        // メニューの横幅指定を一旦無効化
        remove_action('wp_head','biz_vektor_gMenuDivide',170);
        // グローバルメニューを削除
        add_filter('bizvektor_gMenuHtml','vast_gMenu_custom');
        // コンタクトエリアにグローバルメニューを出力
        add_filter('headContactCustom','vast_head_contact_custom');
        // vast用のjs出力
        add_action('wp_enqueue_scripts', 'vast_register_jquery');
        // ヘッダー画像のサイズ変更
        add_filter('biz_vektor_customheader_size', 'biz_vektor_vast_set_customheader', 10, 1);
        // カスタムヘッダー画像のサンプルの追加
        add_filter( 'biz_vektor_customheader_images', 'biz_vektor_vast_add_theme_styles' );
        // カスタマイザーの設定
        add_action( 'customize_register', 'bizvektor_vast_customize_register' );
        // ヘッダーにcss書き出し
        add_action( 'wp_head','biz_vektor_vast_print_css', 150);
    }
}
function biz_vektor_theme_options_vast_init() {
    if (is_vast()){
        if ( false === biz_vektor_get_theme_options_vast() )
            add_option( 'biz_vektor_theme_options_vast' );
            register_setting(
                'biz_vektor_options_vast',
                'biz_vektor_theme_options_vast',
                'biz_vektor_theme_options_vast_validate'
            );
        }
}
/*-------------------------------------------*/
/*  元のグローバルメニューは空にする
/*-------------------------------------------*/
function vast_gMenu_custom(){
    $gMenuHtml = '';
    return $gMenuHtml;
}
/*-------------------------------------------*/
/*  functionsで毎回呼び出して$optionsに入れる処理を他でする。
/*-------------------------------------------*/
function biz_vektor_get_theme_options_vast() {
    return get_option( 'biz_vektor_theme_options_vast' );
}

/*-------------------------------------------*/
/*  変数設定
/*-------------------------------------------*/
function biz_vektor_theme_options_vast_validate( $input ) {
    // 拡張テーマキーカラー
    $output['theme_plusKeyColor']          = $input['theme_plusKeyColor'];
    $output['theme_plusKeyColorLight']     = $input['theme_plusKeyColorLight'];
    $output['theme_plusKeyColorVeryLight'] = $input['theme_plusKeyColorVeryLight'];
    $output['theme_plusKeyColorBorder']    = $input['theme_plusKeyColorBorder'];
    $output['theme_plusColorPoint']        = $input['theme_plusColorPoint'];
    $output['theme_plus_pageTitBnrBg']     = $input['theme_plus_pageTitBnrBg'];
    $output['theme_headerAreaBg']          = $input['theme_headerAreaBg'];
    $output['theme_headerAreaColor']       = $input['theme_headerAreaColor'];
    $output['theme_page_tit_Color']       = $input['theme_page_tit_Color'];
    $output['theme_plus_mobile']           = $input['theme_plus_mobile'];
    $output['theme_plus_pageTitBnrBg_gray']= $input['theme_plus_pageTitBnrBg_gray'];
    return apply_filters( 'biz_vektor_theme_options_vast_validate', $output, $input );
}

/*-------------------------------------------*/
/*  jaの出力
/*-------------------------------------------*/
function vast_register_jquery() {
    wp_register_script( 'vastPlugins' , plugins_url("js/vastplugins.min.js", __FILE__), array('biz-vektor-min-js'), '20150603');
    wp_enqueue_script( 'vastPlugins' );
}


/*-------------------------------------------*/
/*  Print header menu to head contact area
/*-------------------------------------------*/
function vast_head_contact_custom($headContact){
    $gMenuHtml = '';

    // ////////////// SubMenu
    // $sub_menu_args = array(
    //  'theme_location' => 'headerSubMenu',
    //  'fallback_cb' => '',
    //  'echo' => false,
    //  // 'walker' => new description_walker()
    // );
    // $headSubMenu = wp_nav_menu( $sub_menu_args ) ;
 
    ////////////// Global menu
    $args = array(
     'theme_location' => 'Header',
     'fallback_cb' => '',
     'echo' => false,
     'walker' => new description_walker()
    );
    $gMenu = wp_nav_menu( $args ) ;

    // メニューがセットされていたら実行
    if ($gMenu || $gMenuHtml) {
    // ナビのHTMLを一旦変数に格納
    $gMenuHtml .= '
    <!-- [ #gMenu ] -->
    <div id="gMenu">
    <div id="gMenuInner" class="innerBox">
    <h3 class="assistive-text" onclick="showHide(\'header\');"><span>MENU</span></h3>
    <div class="skip-link screen-reader-text">
        <a href=".content" title="'.__('Skip menu', 'biz-vektor').'">'.__('Skip menu', 'biz-vektor').'</a>
    </div>'."\n";

    // メニューがセットされていたら実行
    // if ($headSubMenu) {
    //  $gMenuHtml .= '<div class="headSubMenu">'."\n";
    //  $gMenuHtml .= $headSubMenu;
    //  $gMenuHtml .= '</div>'."\n";
    // }
    $gMenuHtml .= '<div class="headMainMenu">'."\n";
    $gMenuHtml .= $gMenu."\n";
    $gMenuHtml .= '</div>'."\n";
    $gMenuHtml .= '</div><!-- [ /#gMenuInner ] -->
    </div>
    <!-- [ /#gMenu ] -->'."\n";
    } // if ($gMenu) 
    $headContact = $gMenuHtml;
    return $headContact;
}

/*-------------------------------------------*/
// ヘッダー画像のサイズ変更
/*-------------------------------------------*/
function biz_vektor_vast_set_customheader($size=array()){
    $size = array(2000, 1000);
    return $size;
}

function biz_vektor_vast_add_theme_styles($custom_headers){
    //echo plugins_url('/images/castle03.jpg' , __FILE__);

    $plusheaders = array(
        'Matsumoto' => array(
            'url' => plugins_url('/images/castle01.jpg' , __FILE__),
            'thumbnail_url' => plugins_url('/images/castle01-thumbnail.jpg' , __FILE__),
            'description' => 'Castle of Matsumoto'
        ),
        'Inuyama' => array(
            'url' => plugins_url('/images/castle02.jpg' , __FILE__),
            'thumbnail_url' => plugins_url('/images/castle02-thumbnail.jpg' , __FILE__),
            'description' => 'Castle of Inuyama'
        ),
        'raising Inuyama' => array(
            'url' => plugins_url('/images/castle03.jpg' , __FILE__),
            'thumbnail_url' => plugins_url('/images/castle03-thumbnail.jpg' , __FILE__),
            'description' => 'Castle of Inuyama'
        ),
    );
    return array_merge($custom_headers, $plusheaders);  
}

/*-------------------------------------------*/
/*  テーマカスタマイザーの設定
/*-------------------------------------------*/
function bizvektor_vast_customize_register($wp_customize) {
    // Add section
    $wp_customize->add_section( 'biz_vektor_vast', array(
        'title'          => __('Vast 設定', 'biz-vektor'),
        'priority'       => 110,
    ) );
    
    /*  Add text control description
    /*-------------------------------------------*/
   class Custom_Text_Control extends WP_Customize_Control {
        public $type = 'customtext';
        public $description = ''; // we add this for the extra description
        public function render_content() {
        ?>
        <label style="line-height: 140%;">
            <input type="checkbox" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> />
            <strong><?php echo esc_html( $this->label ); ?></strong>           
            <div><?php echo esc_html( $this->description ); ?></div>
        </label>
        <?php
        }
    }


    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plusKeyColor]',
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', ) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plusKeyColorLight]',
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', ) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plusKeyColorVeryLight]',
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', ) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plus_pageTitBnrBg]', 
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', ) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_headerAreaBg]',
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', 'default' => false) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_headerAreaColor]', 
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', 'default' => '#ffffff') );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_page_tit_Color]', 
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', 'default' => '#ffffff') );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plus_mobile]', 
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', ) );
    $wp_customize->add_setting( 'biz_vektor_theme_options_vast[theme_plus_pageTitBnrBg_gray]', 
        array('vast' => '','type'=> 'option','capability' => 'edit_theme_options', 'default' => true) );

    // Create section UI
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'keyColor', array(
        'label'    => __('Keycolor', 'biz-vektor'),
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_plusKeyColor]',
        'description' => '(メニュー背景色の設定は無しでキーカラーを設定した場合、スクロール時のメニュー背景色はキーカラーになります。)',

    )));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'KeyColorLight', array(
        'label'    => __('Keycolor(Light)', 'biz-vektor'),
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_plusKeyColorLight]',
    )));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'KeyColorVeryLight', array(
        'label'    => __('Keycolor(VeryLight)', 'biz-vektor'),
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_plusKeyColorVeryLight]',
    )));

    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'headerAreaBg', array(
        'label'    => 'メニュー背景色',
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_headerAreaBg]',
        'priority'  => 16,
    )));

    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'headerAreaColor', array(
        'label'    => 'メニュー文字色',
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_headerAreaColor]',
        'priority'  => 18,
    )));
    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'page_tit_Color', array(
        'label'    => 'ページタイトル文字色',
        'section'  => 'biz_vektor_vast',
        'settings' => 'biz_vektor_theme_options_vast[theme_page_tit_Color]',
        'priority'  => 19,
    )));

    $wp_customize->add_control( new WP_Customize_Image_Control(
            $wp_customize,
            'page_tit_bnr_bg_url',
            array(
                'label'     => 'ページタイトル背景画像',
                'section'   => 'biz_vektor_vast', 
                'settings'  => 'biz_vektor_theme_options_vast[theme_plus_pageTitBnrBg]',
                'priority'  => 20,
            )
        ));
    $wp_customize->add_control( 'page_tit_bnr_bg_url_txt',
            array(
                'label'     => 'ページタイトル背景画像URL',
                'section'   => 'biz_vektor_vast',
                'settings'  => 'biz_vektor_theme_options_vast[theme_plus_pageTitBnrBg]',
                'type' => 'text',
                'priority' => 21,
            ));
    $wp_customize->add_control( new Custom_Text_Control( $wp_customize, 'page_tit_bnr_bg_url_txt',
            array(
                'label'     => 'メニュー背景色を半透明の灰色に変える',
                'section'   => 'biz_vektor_vast',
                'settings'  => 'biz_vektor_theme_options_vast[theme_plus_pageTitBnrBg_gray]',
                'type' => 'checkbox',
                'priority' => 17,
                'description' => '(チェックが入った状態で、メニュー背景色を設定しても、背景色は変わりません。チェックを外すと背景色がつきます。)',
                )
            ));


    $wp_customize->add_control( new WP_Customize_Image_Control(
            $wp_customize,
            'page_tit_bnr_bg_url_mobile',
            array(
                'label'     => 'ヘッダー画像モバイル端末用',
                'section'   => 'biz_vektor_vast', 
                'settings'  => 'biz_vektor_theme_options_vast[theme_plus_mobile]',
                'priority'  => 22,
            )
        ));
    $wp_customize->add_control( 'page_tit_bnr_bg_url_txt_mobile',
            array(
                'label'     => 'ヘッダー画像モバイル端末用URL',
                'section'   => 'biz_vektor_vast',
                'settings'  => 'biz_vektor_theme_options_vast[theme_plus_mobile]',
                'type' => 'text',
                'priority' => 23,
        ));
}


/*-------------------------------------------*/
/*  Print head
/*-------------------------------------------*/
function biz_vektor_vast_print_css(){
    $vastOptions = biz_vektor_get_theme_options_vast();
    $page_tit_bnr_url = (isset($vastOptions['theme_plus_pageTitBnrBg']))? $vastOptions['theme_plus_pageTitBnrBg']: '' ;
    if (!$page_tit_bnr_url) {
        $page_tit_bnr_url = plugins_url("images/pageTitBnr_bg_01.jpg", __FILE__);
    }
    $page_tit_bnr_url = apply_filters( 'vast_vast_the_page_tit_bnr_bg_url_custom', $page_tit_bnr_url );
    $vast_array = array(
        array(
            'key' => 'theme_plusKeyColor',
            'name' => 'Keycolor',
            'default' => '#e90000'
            ),
        array(
            'key' => 'theme_plusKeyColorLight',
            'name' => 'Keycolor(Light)',
            'default' => '#ff2924'
            ),
        array(
            'key' => 'theme_plusKeyColorVeryLight',
            'name' => 'Keycolor(VeryLight)',
            'default' => '#fff5f5'
            ),
        array(
            'key' => 'theme_headerAreaBg',
            'name' => 'HeaderBg',
            'default' => false
            ),
        array(
            'key' => 'theme_headerAreaColor',
            'name' => 'HeaderColor',
            'default' => '#ffffff'
            ),
        array(
            'key' => 'theme_plus_pageTitBnrBg_gray',
            'name' => 'bg',
            'default' => true
            ),
        array(
            'key' => 'theme_page_tit_Color',
            'name' => 'PagetitColor',
            'default' => '#ffffff'
            ),
        array(
            'key' => 'theme_plus_mobile',
            'name' => 'mobileheaderimage',
            'default' => false //plugins_url("images/matsumoto_mobile.jpg", __FILE__)
            ),
        );
    // 設定項目をループする
    foreach ($vast_array as $key => $value) {
        if (isset($vastOptions[$value['key']])) {
            // 保存されている配列の中に ループ中の項目が保存されていれば $color_key に代入
            $color_key[$value['key']] = esc_html($vastOptions[$value['key']]);
        } else {
            // 保存されている配列の中に ループ中の項目が保存されていなければ 初期値を代入
            $color_key[$value['key']] = $value['default'];
        }
    }
        if ( $vastOptions ) : ?>
        <style type="text/css">

a { color:<?php echo $color_key['theme_plusKeyColorLight'];?> }

#searchform input[type=submit],
p.form-submit input[type=submit],
form#searchform input#searchsubmit,
.content form input.wpcf7-submit,
#confirm-button input,
a.btn,
.linkBtn a,
input[type=button],
input[type=submit],
.sideTower li#sideContact.sideBnr a { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }

.moreLink a { color:<?php echo $color_key['theme_plusKeyColor'];?>; border-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.moreLink a:hover { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content #topPr h3 a:hover,
.moreLink a:after { color:<?php echo $color_key['theme_plusKeyColor'];?>; }

::selection { background-color:<?php echo $color_key['theme_plusKeyColorLight'];?>; }
::-moz-selection { background-color:<?php echo $color_key['theme_plusKeyColorLight'];?>; }

#header.opacyHeader { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
#headerTop { border-top-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
#header.itemOpen { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.headMainMenu li:hover {  }

.content h2:after,
.content h1.contentTitle:after,
.content h1.entryPostTitle:after,
.content .sideWidget h4:after { border-bottom-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content h3:after,
.content .child_page_block h4:after { border-bottom-color:<?php echo $color_key['theme_plusKeyColor'];?>; }

.sideTower li#sideContact.sideBnr a:hover,
form#searchform input#searchsubmit:hover { background-color:<?php echo $color_key['theme_plusKeyColorLight'];?>; }

#panList .innerBox ul a:hover { color:<?php echo $color_key['theme_plusKeyColorLight'];?>; }

.content .mainFootContact p.mainFootTxt span.mainFootTel { color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content .mainFootContact .mainFootBt a { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content .mainFootContact .mainFootBt a:hover { background-color:<?php echo $color_key['theme_plusKeyColorLight'];?>; }

.content .infoList .infoCate a,
.content .infoList .rssBtn a { background-color:<?php echo $color_key['theme_plusKeyColorVeryLight'];?>;color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content .infoList .infoCate a:hover,
.content .infoList .rssBtn a:hover { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.content .infoList ul li .infoTxt a:hover,
.content .infoList .infoListBox div.entryTxtBox h4.entryTitle a:hover { color:<?php echo $color_key['theme_plusKeyColor'];?>; border-bottom-color:<?php echo $color_key['theme_plusKeyColor'];?>;}

.content ul.linkList li a:hover { color:<?php echo $color_key['theme_plusKeyColor'];?>; }

.paging span,
.paging a   { color:<?php echo $color_key['theme_plusKeyColor'];?>;border-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
.paging span.current,
.paging a:hover { background-color:<?php echo $color_key['theme_plusKeyColor'];?>; }

/* アクティブのページ */
.sideTower .sideWidget li > a:hover,
.sideTower .sideWidget li.current_page_item > a,
.sideTower .sideWidget li.current-cat > a   { color:<?php echo $color_key['theme_plusKeyColor'];?>; background-color:<?php echo $color_key['theme_plusKeyColorVeryLight'];?>; }

.sideTower .ttBoxSection .ttBox a:hover { color:<?php echo $color_key['theme_plusKeyColor'];?>; }

#footMenu { border-top-color:<?php echo $color_key['theme_plusKeyColor'];?>; }
#footMenu .menu li a:hover,
#footerSiteMap .menu a:hover { color:<?php echo $color_key['theme_plusKeyColor']; ?> }

@media (min-width: 970px) {
.content .childPageBox ul li a:hover,
.content .childPageBox ul li.current_page_item a { color:<?php echo $color_key['theme_plusKeyColor'];?>; }
}

#pageTitBnr { background-image: url('<?php echo esc_url($page_tit_bnr_url); ?>'); background-position: center center;  background-repeat: no-repeat; }
#pageTitBnr #pageTitInner #pageTit{ color:<?php echo $color_key['theme_page_tit_Color'];?>; }

<?php if($color_key['theme_headerAreaBg']): ?>
#header { background-color:<?php echo $color_key['theme_headerAreaBg']; ?>; box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.1); }
#header.itemOpen { background-color:<?php echo $color_key['theme_headerAreaBg']; ?>; }
#header #headerInner { border-bottom: none !important; }
<?php endif; ?>
<?php if($color_key['theme_plus_pageTitBnrBg_gray']): ?>
#header {background-color: rgba(0,0,0,0.25);}
<?php endif; ?>
#gMenu .assistive-text { color:<?php echo $color_key['theme_headerAreaColor']; ?>; border-color:<?php echo $color_key['theme_headerAreaColor']; ?>; }
#header .innerBox #site-title a { color:<?php echo $color_key['theme_headerAreaColor'];?>; }
@media (min-width: 970px) {
/*#header #headerInner { border-bottom-color:<?php echo $color_key['theme_headerAreaColor'];?> };*/
#headerTop #site-description,   
.headMainMenu .menu > li > a { color:<?php echo $color_key['theme_headerAreaColor'];?>; }
}

</style>
<!--[if lte IE 8]>
<style type="text/css">
.headMainMenu li:hover li a:hover { color:#333; }
.headMainMenu li.current-page-item a,
.headMainMenu li.current_page_item a,
.headMainMenu li.current-menu-ancestor a,
.headMainMenu li.current-page-ancestor a { color:#333;}
.headMainMenu li.current-page-item a span,
.headMainMenu li.current_page_item a span,
.headMainMenu li.current-menu-ancestor a span,
.headMainMenu li.current-page-ancestor a span { color:<?php echo $color_key['theme_plusKeyColor'];?>; }
</style>
<![endif]-->
<script type="text/javascript">
var bizvektor_vast = {"theme_plus_mobile":<?php echo ($color_key['theme_plus_mobile'])? '"'.$color_key['theme_plus_mobile'].'"': 'false'; ?>,"headerAreaBg":<?php echo ($color_key['theme_headerAreaBg'])? 'true': 'false'; ?>};
</script>
<?php endif; // if ( $vastOptions )
}